#ifndef SST_SEP_ATP_AESKEYASYMAUTHENTICATOR_H
#define SST_SEP_ATP_AESKEYASYMAUTHENTICATOR_H
#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 01 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_AesKeyAsymAuthenticator.h#1:incl:1
   *  \author tanian
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
typedef struct TST_ATP_AesKeyAuthTestDataStruct{	
    DxChar                      TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
    DxUint32_t                  TST_KeySizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize; 
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_EncChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_AesKeyAuthTestDataStruct;

/*****************************************************************************
* Function Name:
*  SEPQA_SST_AesKeyAsymAuthenticator
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the creation, deletion, modification, opening, closing and usage of a shared key authenticator object.
* And demonstration on the use of transaction with authenticator objects
*  
* Algorithm:
*     1.  Create a new session by calling: SST_SessionCreate.
*     2.  Open a transaction by calling: SST_TransactionStart.
*     3.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorAESSharedSecretCreate.
*     4.  Close the transaction by calling: SST_TransactionClose.
*     5.  Open a transaction by calling: SST_TransactionStart.
*     6.  Open the new authenticator by calling: 
*          i.   SST_AuthenticatorChallengeGet 
*          ii.  CRYS_AES (Encrypt the challenge using the AES key)
*          iii. SST_AuthenticationOpen.
*     7.  Close the transaction by calling: SST_TransactionClose.
*     8.  Open a transaction by calling: SST_TransactionStart.
*     9.  Insert a new data object by calling: SST_InsertData.
*     10. Close the authenticator by calling: SST_AuthenticationClose.
*     11. Open the new authenticator by calling: 
*          i.   SST_AuthenticatorChallengeGet 
*          ii.  CRYS_AES (Encrypt the challenge using the AES key)
*          iii. SST_AuthenticationOpen.
*     12.Close the transaction by calling: SST_TransactionClose.
*     13.Open a transaction by calling: SST_TransactionStart.
*     14.Delete the data by calling: SST_DeleteData.
*     15.Close the authenticator by calling: SST_AuthenticationClose.
*     16.Delete the authenticator by calling: SST_AuthenticatorDelete.
*     17.Close the transaction by calling: SST_TransactionClose.
*     18.Delete the session by calling: SST_SessionDelete.
* 
*******************************************************************************/
DxError_t SEPQA_SST_AesKeyAsymAuthenticator ( void );

#ifdef __cplusplus
}


#endif

#endif



